<?php

namespace backend\models\form;

use backend\models\db\Jar;

/**
 * New jar form
 */
class CreateJar extends \yii\base\Model {

    public $name;
    public $budget_id;

    public function rules() {

        // validate input
        $validationRules = [
            ['name', 'required'],
            ['name', 'string', 'min' => 3],
            ['name', 'jarNameUnique'],
            ['name', 'jarNameNotSpecial']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];

        return array_merge($validationRules, $filterRules);

    }

    /**
     * Check whether jar name is allowed.
     */
    public function jarNameUnique($attribute) {

        $jar = Jar::findOne(['name' => $this->name, 'budget_id' => $this->budget_id]);

        if ($jar) {

            $this->addError($attribute, 'Please enter a unique jar name.');

        }

    }


    /**
     * Check if jar name is not a special, forbidden name
     */
    public function jarNameNotSpecial() {

        $forbiddenNames = [
            'debts',
            'interest'
        ];

        if (in_array(strtolower($this->name), $forbiddenNames)) {

            $this->addError($this->name, "\"{$this->name}\" is not a valid jar name.");

        }

    }

}
