<?php

namespace backend\models\form;

use backend\components\validators\Currency;
use backend\models\db\Account;

/**
 * New eoms summary account balance form
 */
class EditSummaryAccountBalance extends \yii\base\Model
{
    public $current_balance;
    public $adjustment_amount;
    public $balance;
    public $summary_balance;
    public $budget_id = -1;
    public $account_id;
    public $archived;

    public function rules() {

        // validate input
        $validationRules = [
            [['balance', 'summary_balance'], 'required'],
            [['current_balance', 'adjustment_amount', 'balance', 'summary_balance'], Currency::className()],
            ['account_id', 'integer'],
            ['account_id', 'accountIdValid']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim'],
            [['balance', 'summary_balance'], 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];

        return array_merge($validationRules, $filterRules);

    }

    /**
     * Check if the account ID can be accessed by this user
     */
    public function accountIdValid($attribute) {

        $account = Account::findOne([
            'budget_id' => $this->budget_id,
            'id' => $this->{$attribute}
        ]);

        if (!$account) {

            $this->addError($attribute, 'Invalid account ID.');

        }

    }

}
