<?php

namespace backend\models\form;

use backend\components\validators\Currency;
use backend\models\db\Debt;

/**
 * New eoms summary debt amount form
 */
class EditSummaryDebtAmount extends \yii\base\Model
{
    public $current_amount;
    public $adjustment_amount;
    public $amount;
    public $budget_id = -1;
    public $debt_id;
    public $archived;

    public function rules()
    {
        // validate input
        $validationRules = [
            ['amount', 'required'],
            [['current_amount', 'amount', 'adjustment_amount'], Currency::className()],
            ['debt_id', 'integer'],
            ['debt_id', 'debtIdValid']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim'],
            ['amount', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];
        return array_merge($validationRules, $filterRules);
    }

    /**
     * Check if the account ID can be accessed by this user
     */
    public function debtIdValid($attribute)
    {
        $account = Debt::findOne([
            'budget_id' => $this->budget_id,
            'id' => $this->{$attribute}
        ]);

        if (!$account) {
            $this->addError($attribute, 'Invalid debt ID.');
        }
    }

}
