<?php

namespace backend\models\form;
use backend\components\validators\Currency;


/**
 * New eoms summary account balance form
 */
class EditSummaryNextMonthsEverydayAllowance extends \yii\base\Model
{
    public $amount;
    public $budget_id = -1;

    public function rules()
    {
        // validate input
        $validationRules = [
            ['amount', 'required'],
            ['amount', Currency::className()]
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim'],
            ['amount', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];
        return array_merge($validationRules, $filterRules);
    }
}
