<?php

namespace backend\models\form;

use backend\components\validators\Currency;
use backend\models\db\Income;
use backend\models\form\common\DateField;

/**
 * New jar form
 */
class IncomeTransactionEntry extends \yii\base\Model
{
    use DateField;

    public $generate;
    public $amount;
    public $date;
    public $income_id;
    public $budget_id;


    public function rules() {
        // validate input
        $validationRules = [
            ['amount', 'required', 'when' => function($model) {
                return $model->generate;
            }, 'whenClient' => 'function(field) {
                var checkboxId = field.id.replace(\'amount\', \'generate\');
                return $(\'#\' + checkboxId).is(\':checked\');
            }'],
            ['amount', Currency::className(), 'min' => '0.01'],
            ['generate', 'integer', 'min' => 0, 'max' => 1],
            ['income_id', 'required'],
            ['income_id', 'integer'],
            ['income_id', 'incomeIdValid'],
            ['date', 'required'],
            ['date', 'dateValid'],
            ['budget_id', 'integer']
        ];

        // sanitize
        $filterRules = [
//            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
//            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
            ['amount', 'filter', 'filter' => ['backend\components\helpers\Formatter', 'currencyToDecimal']]
        ];

        return array_merge($this->dateRules(), $validationRules, $filterRules);
    }


    public function incomeIdValid($attribute)
    {
        $income = Income::findOne(['id' => $this->{$attribute}, 'budget_id' => $this->budget_id]);
        if (!$income) {
            $this->addError($attribute, 'Invalid income ID.');
        }
    }


    public function dateValid($attribute)
    {
        $dateTime = strtotime($this->{$attribute});
        $startTime = strtotime(date('Y-m-1'));
        $endTime = strtotime('-1 DAY');
        if (($dateTime > $endTime) || ($dateTime < $startTime)) {
            $this->addError($attribute, 'Invalid date.');
        }
    }

}
