<?php

namespace backend\models\form;

use backend\models\db\Account;

/**
 * New expense form
 */
class RemoveAccount extends \yii\base\Model
{
    public $new_account_id;
    public $debt_account_id;
    public $expense_account_id;
    public $income_account_id;
    public $transfer_account_id;
    public $default_account_id;
    public $is_default_account = false;
    public $budget_id = false;

    public function rules()
    {
        // validate input
        $validationRules = [
            ['new_account_id', 'required', 'message' => 'Transfer account cannot be blank.'],
            ['new_account_id', 'integer'],
            ['new_account_id', 'accountIdValid'],
            ['debt_account_id', 'required', 'message' => 'Please select account for debts.', 'when' => function($model) {
                return !empty($model->debt_account_id);
            }],
            ['debt_account_id', 'integer'],
            ['expense_account_id', 'required', 'message' => 'Please select account for expenses.', 'when' => function($model) {
                return !empty($model->expense_account_id);
            }],
            ['expense_account_id', 'integer'],
            ['income_account_id', 'required', 'message' => 'Please select account for incomes.', 'when' => function($model) {
                return !empty($model->income_account_id);
            }],
            ['income_account_id', 'integer'],
            ['transfer_account_id', 'required', 'message' => 'Please select account for transfers.', 'when' => function($model) {
                return !empty($model->transfer_account_id);
            }],
            ['transfer_account_id', 'integer'],
            ['default_account_id', 'required', 'message' => 'Default account cannot be blank.', 'when' => function($model) {
                return $this->is_default_account;
            }],
            ['default_account_id', 'integer', 'min' => 1],
            ['default_account_id', 'accountIdValid']
        ];

        // sanitize
        $filterRules = [
            [['new_account_id'], 'filter', 'filter' => 'strip_tags'],
            [['new_account_id'], 'filter', 'filter' => 'trim']
        ];

        return array_merge($validationRules, $filterRules);
    }

    /**
     * Check if the account ID can be accessed by this user
     */
    public function accountIdValid($attribute)
    {
        if ($this->{$attribute} != 0) {
            $account = Account::findOne([
                'budget_id' => $this->budget_id,
                'id' => $this->{$attribute}
            ]);
            if (!$account) {
                $this->addError($attribute, 'Invalid account ID.');
            }
        }
    }

}
