<?php

namespace backend\models\form;


/**
 * Snooze a notification
 */
class SnoozeNotification extends \yii\base\Model {

    public $period_id;
    public $hours;

    public function rules() {

        // validate input
        $validationRules = [
            ['period_id', 'integer']
        ];

        // sanitize
        $filterRules = [
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'strip_tags'],
            [array_keys($this->getAttributes()), 'filter', 'filter' => 'trim']
        ];

        $operations = [
            ['period_id', 'periodIdToHours']
        ];

        return array_merge($filterRules, $validationRules, $operations);

    }


    /**
     * Set the models hours based on period ID.
     */
    public function periodIdToHours($attribute) {

        switch ($this->period_id) {

            case 0:
                $this->hours = 24;
                break;

            case 1:
                $this->hours = 48;
                break;

            default:
                $this->addError($attribute, 'Invalid period selected');

        }

    }

}
