<?php

namespace backend\models\form\common;

use backend\components\helpers\Formatter;


/**
 * This trait helps with adding custom behavior to all the form classes
 * that support date field that is formatted according to the user's settings
 * @package backend\models\form\common
 */
trait DateField
{
    public function dateRules()
    {
        return [
            ['formattedDate', 'safe']
        ];
    }

    public function getFormattedDate()
    {
        return $this->date ? Formatter::date($this->date) : null;
    }

    public function setFormattedDate($date)
    {
        $this->date = $date;
    }
}