<?php

namespace backend\models\form\common;

use backend\components\helpers\Formatter;


/**
 * This trait helps with adding custom behavior to all the form classes
 * that support date field that is formatted according to the user's settings
 * @package backend\models\form\common
 */
trait EndDateField
{
    public function endDateRules()
    {
        return [
            ['formattedEndDate', 'safe']
        ];
    }

    public function getFormattedEndDate()
    {
        return $this->endDate ? Formatter::date($this->endDate) : null;
    }

    public function setFormattedEndDate($date)
    {
        $this->endDate = $date;
    }
}