<?php

namespace backend\models\form\common;

use backend\components\helpers\Formatter;


/**
 * This trait helps with adding custom behavior to all the form classes
 * that support date field that is formatted according to the user's settings
 * @package backend\models\form\common
 */
trait RepeatUntilDateField
{
    public function repeatUntilDateRules()
    {
        return [
            ['formattedRepeatUntilDate', 'safe']
        ];
    }

    public function getFormattedRepeatUntilDate()
    {
        return $this->repeatUntilDate ? Formatter::date($this->repeatUntilDate) : null;
    }

    public function setFormattedRepeatUntilDate($date)
    {
        $this->repeatUntilDate = $date;
    }
}