<?php

namespace backend\modules\admin\controllers;

use Yii;

use backend\components\helpers\JsonTools;
use backend\models\db\FaqQuestion;
use backend\modules\admin\models\search\FaqQuestionSearch;
use backend\components\CustomController;
use yii\web\HttpException;
use yii\helpers\Url;
use yii\filters\AccessControl;
use dmstr\bootstrap\Tabs;

/**
 * FaqQuestionController implements the CRUD actions for FaqQuestion model.
 */
class FaqQuestionController extends CustomController
{

    public $enableCsrfValidation = false;

    public function behaviors() {

        return [
            'access' => [
                'class' => AccessControl::className(),
                'rules' => [
                    [
                        'actions' => [
                            'index',
                            'view',
                            'create',
                            'update',
                            'delete'
                        ],
                        'allow' => true,
                        'roles' => ['superadmin'],
                    ],
                ],
            ]
        ];

    }


    /**
     * Lists all FaqQuestion models.
     * @return mixed
     */
    public function actionIndex()
    {
        $searchModel = new FaqQuestionSearch;
        $dataProvider = $searchModel->search($_GET);

        Tabs::clearLocalStorage();

        Url::remember();
        \Yii::$app->session['__crudReturnUrl'] = null;

        $this->view->title = 'FAQ Questions';

        return $this->render('index', [
            'dataProvider' => $dataProvider,
            'searchModel' => $searchModel,
        ]);
    }

    /**
     * Displays a single FaqQuestion model.
     * @param integer $id
     *
     * @return mixed
     */
    public function actionView($id)
    {
        \Yii::$app->session['__crudReturnUrl'] = Url::previous();
        Url::remember();
        Tabs::rememberActiveState();

        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new FaqQuestion model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return mixed
     */
    public function actionCreate()
    {
        $model = new FaqQuestion;

        if ($model->load($_POST)) {
            if (\Yii::$app->request->isAjax) {
                if ($model->validate()) {
                    $model->save(false);
                    return JsonTools::successMessage('FAQ successfully created.');
                } else {
                    return JsonTools::formErrorMessage($model);
                }
            }
        } else {
            return $this->render('create', ['model' => $model]);
        }

    }

    /**
     * Updates an existing FaqQuestion model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param integer $id
     * @return mixed
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load($_POST)) {
            if (\Yii::$app->request->isAjax) {
                if ($model->validate()) {
                    $model->save(false);

                    return JsonTools::successMessage('FAQ successfully edited.');
                } else {
                    return JsonTools::formErrorMessage($model);
                }
            }

        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing FaqQuestion model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param integer $id
     * @return mixed
     */
    public function actionDelete($id)
    {

        $confirm = Yii::$app->getRequest()->getQueryParam('confirm', false);

        if ($confirm) {

            $this->findModel($id)->delete();

            echo JsonTools::successMessage('Question successfully deleted.');
            die();

        }
        else {

            $this->view->title = 'Delete FAQ Question';

            return $this->render('delete-faq-question', [
                'questionId' => $id
            ]);

        }
    }

    /**
     * Finds the FaqQuestion model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return FaqQuestion the loaded model
     * @throws HttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = FaqQuestion::findOne($id)) !== null) {
            return $model;
        } else {
            throw new HttpException(404, 'The requested page does not exist.');
        }
    }
}
