<?php

namespace backend\modules\admin\models\search;

use yii\base\Model;
use yii\data\ActiveDataProvider;
use backend\models\db\FaqCategory;

/**
* FaqCategorySearch represents the model behind the search form about `backend\models\db\FaqCategory`.
*/
class FaqCategorySearch extends FaqCategory
{
/**
* @inheritdoc
*/
public function rules()
{
return [
[['id', 'archived'], 'integer'],
            [['name', 'description'], 'safe'],
];
}

/**
* @inheritdoc
*/
public function scenarios()
{
// bypass scenarios() implementation in the parent class
return Model::scenarios();
}

/**
* Creates data provider instance with search query applied
*
* @param array $params
*
* @return ActiveDataProvider
*/
public function search($params)
{
$query = FaqCategory::find();

$dataProvider = new ActiveDataProvider([
'query' => $query,
]);

$this->load($params);

if (!$this->validate()) {
// uncomment the following line if you do not want to any records when validation fails
// $query->where('0=1');
return $dataProvider;
}

$query->andFilterWhere([
            'id' => $this->id,
            'archived' => $this->archived,
        ]);

        $query->andFilterWhere(['like', 'name', $this->name])
            ->andFilterWhere(['like', 'description', $this->description]);

return $dataProvider;
}
}
