<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;

?>
<div id="body" class="container-fluid" data-js-callback="messagingLoaded" data-select-menu="li#admin-sessions" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3><?= Html::encode($this->title) ?></h3>
            </div>
        </div>
    </div>

    <div class="row appointments mb40">
        <div class="col-md-8">
            <div class="panel no-padding">
                <div class="clearfix">
                    <div class="item-list bookings">
                        <div class="item item-top">
                            This month's booked sessions <span><?= count($bookedAppointments) ?></span>
                        </div>
                        <?php if (count($bookedAppointments)) { ?>
                        <?php foreach ($bookedAppointments as $b) { ?>
                        <div class="item active clearfix">
                            <div class="item-date"><?php if ($b->getDaysUntil() < 1) {
                                echo '<i class="glyphicon glyphicon-exclamation-sign red"></i>';
                            }
                            elseif ($b->getDaysUntil() < 7) {
                                echo '<i class="glyphicon glyphicon-exclamation-sign orange"></i>';
                            }
                            ?> <?= $b->user->getFullName() . ' &nbsp; => &nbsp; ' . $b->appointmentUser->user->getFullName()?></div>
                            <div class="item-time"><?= Formatter::datetime(strtotime($b->datetime)) ?></div>
                        </div>
                        <?php } ?>
                        <?php } ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>
