<?php

use yii\helpers\Html;
use yii\bootstrap\ActiveForm;
use \dmstr\bootstrap\Tabs;

/**
 * @var yii\web\View $this
 * @var backend\models\db\Bugs $model
 * @var yii\widgets\ActiveForm $form
 */

?>

<div class="panel panel-default">
    <div class="panel-heading">
        <h2>
            <?= $model->id ?>        </h2>
    </div>

    <div class="panel-body">

        <div class="bugs-form">

            <?php $form = ActiveForm::begin([
                    'id' => 'Bugs',
                    'enableClientValidation' => true,
                    'errorSummaryCssClass' => 'error-summary alert alert-error'
                ]
            );
            ?>

            <div class="">
                <?php $this->beginBlock('main'); ?>

                <p>

                    <?= $form->field($model, 'id')->textInput() ?>
                    <?= // generated by schmunk42\giiant\generators\crud\providers\RelationProvider::activeField
                    $form->field($model, 'user_id')->dropDownList(
                        \yii\helpers\ArrayHelper::map(backend\models\db\User::find()->all(), 'id', 'username'),
                        ['prompt' => 'Select']
                    ); ?>
                    <?= $form->field($model, 'content')->textarea(['rows' => 6]) ?>
                    <?= $form->field($model, 'time')->textInput() ?>
                    <?= $form->field($model, 'url')->textInput(['maxlength' => true]) ?>
                    <?= $form->field($model, 'archived')->dropDownList(['No', 'Yes']) ?>
                </p>
                <?php $this->endBlock(); ?>

                <?=
                Tabs::widget(
                    [
                        'encodeLabels' => false,
                        'items' => [
                            [
                                'label' => 'Bugs',
                                'content' => $this->blocks['main'],
                                'active' => true,
                            ],
                        ]
                    ]
                );
                ?>
                <hr/>
                <?php echo $form->errorSummary($model); ?>
                <?= Html::submitButton(
                    '<span class="glyphicon glyphicon-check"></span> ' .
                    ($model->isNewRecord ? 'Create' : 'Save'),
                    [
                        'js-callback' => 'reloadPjaxMain',
                        'id' => 'save-' . $model->formName(),
                        'class' => 'btn btn-success'
                    ]
                );
                ?>

                <?php ActiveForm::end(); ?>

            </div>

        </div>

    </div>

</div>
