<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use backend\widgets\FormattedTitle;

?>

<div class="content-container faq-question-index">
    <div id="body" class="container-fluid" data-select-menu="li#admin-bugs" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
        <div class="row">
            <div class="col-md-12">

                    <?php \yii\widgets\Pjax::begin([
                        'id' => 'pjax-main',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-main ul.pagination a, th a',
                        //'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>

                        <div class="col-head">
                            <h2>
                                <i><?= 'Bugs' ?></i>
                            </h2>
                        </div>

                        <div class="panel panel-table no-border margin-top">

                            <div class="table-responsive">
                                <?= GridView::widget([
                                    'layout' => '{pager}{items}{pager}{summary}',
                                    'dataProvider' => $dataProvider,
                                    'pager' => [
                                        'class' => yii\widgets\LinkPager::className(),
                                        'firstPageLabel' => 'First',
                                        'lastPageLabel' => 'Last'
                                    ],
                                    'filterModel' => $searchModel,
                                    'tableOptions' => ['class' => 'table table-striped table-bordered table-hover'],
                                    'columns' => [

                                        [
                                            'class' => 'yii\grid\ActionColumn',
                                            'urlCreator' => function ($action, $model, $key, $index) {
                                                // using the column name as key, not mapping to 'id' like the standard generator
                                                $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                                $params[0] = \Yii::$app->controller->id ? \Yii::$app->controller->id . '/' . $action : $action;
                                                return Url::toRoute($params);
                                            },
                                            'contentOptions' => ['nowrap' => 'nowrap'],
                                            'template' => '{view}'
                                        ],
                                        [
                                            'class' => yii\grid\DataColumn::className(),
                                            'attribute' => 'user_id',
                                            'value' => function ($model) {
                                                if ($rel = $model->getUser()->one()) {
                                                    return Html::a($rel->username, ['user/view', 'id' => $rel->id,],
                                                        ['data-pjax' => 0]);
                                                } else {
                                                    return '';
                                                }
                                            },
                                            'format' => 'raw',
                                        ],
                                        'content:ntext',
                                        'time:datetime',
                                        'url:url',
                                        'archived:boolean',
                                    ],
                                ]); ?>
                            </div>

                        </div>

                    </div>

                    <?php \yii\widgets\Pjax::end() ?>


                </div>
            </div>
        </div>
    </div>
</div>
