<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<nav id="secondary-side-bar" class="navmenu navmenu-default navmenu-fixed-left" role="navigation">
    <div id="seconday-side-bar-header">
        <h2>Users</h2>
    </div>
    <ul id="secondary-side-bar-nav" class="nav navmenu-nav panel-group clients conversation-clients" role="tablist" aria-multiselectable="true">
        <?php /** @var \backend\models\db\User $c */
        foreach ($clients as $c) {
            $active = (isset($clientId) && ($c->id == $clientId)) ? ' class="active"' : '';
            $conv = $c->getMainConversation();
            $lastMessage = $conv->getLastMessage(); ?>
        <li<?= $active ?> data-user-id="<?= $c->id ?>">
            <a href="<?= Url::toRoute(['/admin/coach/conversation-detail', 'client_id' => $c->id]) ?>">
                <span class="avatar-part">
                    <?= $c->unread_messages ? '<span class="alert-count">'.$c->unread_messages.'</span>' : '' ?>
                    <img class="avatar" src="<?= $c->getAvatarUrl() ?>">
                </span>
                <span class="message-part">
                    <span class="name"><strong><?= $c->getFullName(true) ?></strong></span>
                    <?= $lastMessage ? '<span class="date">'.Formatter::datetime(Formatter::utcDatetimeToLocalDatetime($lastMessage->time, $timezone->code, 'Y-m-d H:i:s')).'</span>' : '' ?>
                </span>
            </a>
        </li>
        <?php } ?>
    </ul>
</nav>
