<?php
use backend\components\helpers\Calculator;
use backend\components\helpers\Formatter;
use dosamigos\datetimepicker\DateTimePicker;
use dosamigos\typeahead\TypeAhead;
use yii\helpers\ArrayHelper;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin([
    'id' => 'add-appointment-form'
]); ?>
<div class="modal-body">

    <div class="message"></div>

    <div class="row">
        <div class="col-md-12">
            <?= $form->field($formModel, 'timeSlotItemId')
                ->dropDownList($availableSlots, ['encode' => false])
                ->label('Time Slot') ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'userId')
                ->dropDownList($users)
                ->label('User') ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'startDateTime')
                ->dropDownList($hours !== null ? $hours : [])
                ->label('Start Time') ?>
        </div>
    </div>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Appointment', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => 'reloadAppointmentsDay',
        'data-submit-url' => Url::toRoute('/admin/coach/add-appointment')
    ]); ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


