<?php
use backend\components\helpers\Calculator;
use backend\components\helpers\Formatter;
use dosamigos\datetimepicker\DateTimePicker;
use dosamigos\typeahead\TypeAhead;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin([
    'id' => 'confirm-action-form'
]); ?>
<div class="modal-body">

    <div class="message"></div>

    <div class="row">
        <div class="col-md-12">
            <?php if (count($item->timeSlot->timeSlotBookings) > 0) { ?>
            <p class="text-danger">There are booked appointments for this time-slot.</p>
            <ul>
                <?php foreach ($item->timeSlot->timeSlotBookings as $booking) { ?>
                <li><?= $booking->getBookingInfo($timezone) ?></li>
                <?php } ?>
            </ul>
            <p class="text-danger">Deleting it will also cancel all related bookings for the deleted dates.</p>
            <?php } ?>
            <?php if ($item->timeSlot->repeat) { ?>
            <p>How do you want to apply this change?</p>
            <ul>
                <li>Only this time-slot (<strong><?= $itemDate ?></strong>) will be deleted</li>
                <li>This (<strong><?= $itemDate ?></strong>) and all future time-slots will be deleted</li>
            </ul>
            <?php } else { ?>
            <p>Are you sure you want to delete this time-slot (<strong><?= $itemDate ?></strong>)?</p>
            <?php } ?>
        </div>
    </div>

</div>
<div class="modal-footer">
    <?php
    echo Html::submitButton('Cancel', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']);
    if ($item->timeSlot->repeat) {
        echo Html::submitButton('Only this Time-slot', [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute(['/admin/coach/delete-time-slot', 'id' => $item->id, 'confirm' => 1, 'all' => 0])
        ]);
        echo Html::submitButton('This and all future Time-slots', [
            'class' => 'btn btn-danger ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute(['/admin/coach/delete-time-slot', 'id' => $item->id, 'confirm' => 1, 'all' => 1])
        ]);
    }
    else {
        echo Html::submitButton('Delete this Time-slot', [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute(['/admin/coach/delete-time-slot', 'id' => $item->id, 'confirm' => 1, 'all' => 0])
        ]);
    } ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


