<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use backend\widgets\FormattedTitle;

?>

<div class="content-container faq-category-index">
    <div id="body" class="container-fluid" data-select-menu="li#admin-faq-categories" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
        <div class="row">
            <div class="col-md-12">

                <?php \yii\widgets\Pjax::begin([
                    'id' => 'pjax-main',
                    'enableReplaceState' => false,
                    'linkSelector' => '#pjax-main ul.pagination a, th a',
                    'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                ]) ?>

                <div class="col-head">
                    <h2>
                        <?= $this->title ?>
                    </h2>
                    <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['create']) ?>">
                        <i class="glyphicon glyphicon-plus"></i> Add FAQ Category
                    </a>
                </div>

                <div class="panel panel-table no-border margin-top">

                    <div class="table-responsive">
                        <?= GridView::widget([
                            'layout' => '{pager}{items}{pager}{summary}',
                            'dataProvider' => $dataProvider,
                            'pager' => [
                                'class' => yii\widgets\LinkPager::className(),
                                'firstPageLabel' => 'First',
                                'lastPageLabel' => 'Last'
                            ],
                            'filterModel' => $searchModel,
                            'tableOptions' => ['class' => 'table table-striped table-bordered table-hover'],
                            'headerRowOptions' => ['class' => 'x'],
                            'columns' => [
                                [
                                    'class' => 'yii\grid\ActionColumn',
                                    'urlCreator' => function ($action, $model, $key, $index) {
                                        // using the column name as key, not mapping to 'id' like the standard generator
                                        $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                        $params[0] = \Yii::$app->controller->id ? \Yii::$app->controller->id . '/' . $action : $action;
                                        return Url::toRoute($params);
                                    },
                                    'buttons' => [
                                        'update' => function ($url, $model, $key) {
                                            return Html::a('<span class="glyphicon glyphicon-pencil"></span>',
                                                '#', [
                                                    'title' => 'Update',
                                                    'aria-label' => 'Update',
                                                    'class' => 'open-modal',
                                                    'data' => [
                                                        'modal-url' => $url
                                                    ]
                                                ]);
                                        },
                                        'delete' => function ($url, $model, $key) {
                                            return Html::a('<span class="glyphicon glyphicon-trash"></span>',
                                                '#', [
                                                    'title' => 'Delete',
                                                    'aria-label' => 'delete',
                                                    'class' => 'open-modal',
                                                    'data' => [
                                                        'modal-url' => $url
                                                    ]
                                            ]);
                                        }
                                    ],
                                    'contentOptions' => ['nowrap' => 'nowrap']
                                ],
                                'name',
                                'description:ntext',
                                'order'
                            ],
                        ]); ?>
                    </div>

                </div>

                <?php \yii\widgets\Pjax::end() ?>

            </div>
        </div>
    </div>
</div>
