<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use yii\widgets\DetailView;
use yii\widgets\Pjax;
use dmstr\bootstrap\Tabs;
use backend\widgets\FormattedTitle;

?>
<div id="body" class="container-fluid" data-select-menu="li#admin-faq-categories" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <div class="row">
        <div class="col-md-12">
            <!-- menu buttons -->
            <p class='pull-left'>
                <?= Html::a(
                    '<span class="glyphicon glyphicon-pencil"></span> Update FAQ Category',
                    null,
                    [
                        'class' => 'btn btn-info open-modal',
                        'data' => [
                            'modal-url' => Url::toRoute(['update', 'id' => $model->id])
                        ]
                    ]
                ); ?>
            </p>

            <p class="pull-right">
                <?= Html::a('<span class="glyphicon glyphicon-list"></span> ' . 'List FaqCategories', ['index'],
                    ['class' => 'btn btn-default']) ?>
            </p>

            <div class="clearfix"></div>

            <!-- flash message -->
            <?php if (\Yii::$app->session->getFlash('deleteError') !== null) : ?>
                <span class="alert alert-info alert-dismissible" role="alert">
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span></button>
                    <?= \Yii::$app->session->getFlash('deleteError') ?>
        </span>
            <?php endif; ?>

            <div class="panel panel-default">
                <div class="panel-heading">
                    <h2>
                        <?= $model->name ?>            </h2>
                </div>

                <div class="panel-body">


                    <?php $this->beginBlock('backend\models\db\FaqCategory'); ?>

                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            'id',
                            'name',
                            'description:ntext',
                            'archived:boolean',
                        ],
                    ]); ?>

                    <hr/>

                    <?= Html::a('<span class="glyphicon glyphicon-trash"></span> ' . 'Delete',
                        ['delete', 'id' => $model->id],
                        [
                            'class' => 'btn btn-danger',
                            'data-confirm' => '' . 'Are you sure to delete this item?' . '',
                            'data-method' => 'post',
                        ]); ?>
                    <?php $this->endBlock(); ?>



                    <?php $this->beginBlock('FaqQuestions'); ?>
                    <div style='position: relative'>
                        <div style='position:absolute; right: 0px; top 0px;'>
                            <?= Html::a(
                                '<span class="glyphicon glyphicon-list"></span> ' . 'List All' . ' Faq Questions',
                                ['faq-question/index'],
                                ['class' => 'btn text-muted btn-xs']
                            ) ?>
                            <?= Html::a(
                                '<span class="glyphicon glyphicon-plus"></span> ' . 'New' . ' Faq Question',
                                ['faq-question/create', 'FaqQuestion' => ['faq_category_id' => $model->id]],
                                ['class' => 'btn btn-success btn-xs']
                            ); ?>
                        </div>
                    </div><?php Pjax::begin([
                        'id' => 'pjax-FaqQuestions',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-FaqQuestions ul.pagination a, th a',
                        'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>
                    <?= '<div class="table-responsive">' . \yii\grid\GridView::widget([
                        'layout' => '{summary}{pager}<br/>{items}{pager}',
                        'dataProvider' => new \yii\data\ActiveDataProvider([
                            'query' => $model->getFaqQuestions(),
                            'pagination' => ['pageSize' => 20, 'pageParam' => 'page-faqquestions']
                        ]),
                        'pager' => [
                            'class' => yii\widgets\LinkPager::className(),
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last'
                        ],
                        'columns' => [
                            [
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{view} {update}',
                                'contentOptions' => ['nowrap' => 'nowrap'],
                                'urlCreator' => function ($action, $model, $key, $index) {
                                    // using the column name as key, not mapping to 'id' like the standard generator
                                    $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                    $params[0] = 'faq-question' . '/' . $action;
                                    return $params;
                                },
                                'buttons' => [

                                ],
                                'controller' => 'faq-question'
                            ],
                            'id',
                            'title',
                            'description:ntext',
                            'archived',
                        ]
                    ]) . '</div>' ?>
                    <?php Pjax::end() ?>
                    <?php $this->endBlock() ?>


                    <?= Tabs::widget(
                        [
                            'id' => 'relation-tabs',
                            'encodeLabels' => false,
                            'items' => [
                                [
                                    'label' => '<b class=""># ' . $model->id . '</b>',
                                    'content' => $this->blocks['backend\models\db\FaqCategory'],
                                    'active' => true,
                                ],
                                [
                                    'content' => $this->blocks['FaqQuestions'],
                                    'label' => '<small>Faq Questions <span class="badge badge-default">' . count($model->getFaqQuestions()->asArray()->all()) . '</span></small>',
                                    'active' => false,
                                ],
                            ]
                        ]
                    );
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
