<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;

?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span>
    </button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'create-user-plan-form']); ?>
<div class="modal-body">
    <div class="message"></div>
    <?= Html::activeHiddenInput($model, 'user_id') ?>
    <?= $form->field($model,
        'user_plan_type_id')->dropDownList(\yii\helpers\ArrayHelper::map(\backend\models\db\UserPlanType::find()->all(),
        'id', 'name')) ?>
    <?= $form->field($model, 'start_time')->input('date') ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add User Plan', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => 'reloadAdminUserPlans',
        'data-submit-url' => Url::toRoute(['/admin/user-plan/create', 'user_id' => $model->user_id])
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


