<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'reset-user-form']); ?>
<div class="modal-body">

    <p>
        Do you really wish to reset this user's account?
    </p>
    <p class="text-danger">
        This will remove <strong>ALL</strong> data (expenses, incomes, accounts, etc) for the user
        and start it from scratch. <strong>This operation cannot be reversed.</strong>
    </p>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Reset Account', ['class' => 'btn btn-danger ajax-submit', 'data-js-callback' => 'reloadPjaxMain','data-submit-url' => Url::toRoute(['/admin/user/reset', 'id' => $userId, 'confirm' => '1'])]) ?>
</div>
<?php ActiveForm::end(); ?>
