<?php

use yii\helpers\Html;
use \yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;

?>
<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span>
    </button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>

<?php $form = ActiveForm::begin(['id' => 'admin-edit-user-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <?= $form->field($formModel, 'email')->textInput() ?>
    <?= $form->field($formModel, 'password')->passwordInput() ?>
    <?= $form->field($formModel, 'password_repeat')->passwordInput()->label('Re-type password') ?>
    <?php if ($userRoleId == '4') { ?>
    <?=
    $form->field($formModel, 'user_parent_id', ['options' => ['class' => 'form-group hidden']])->dropDownList($parents,[
        'prompt' => 'Select'
    ])->label('User Parent'); ?>
    <?php } elseif ($userRoleId == 3) { ?>
    <?=
    $form->field($formModel, 'coach_id', ['options' => ['class' => 'form-group']])->dropDownList($coaches,[
        'prompt' => 'Select',
    ])->label('Coach'); ?>
    <?php } ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Save', [
        'class' => 'btn btn-primary ajax-submit',
        'data' => [
            'js-callback' => 'reloadPjaxMain',
            'submit-url' => Url::toRoute(['/admin/user/update', 'id' => $userId]),
        ]
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>

