<?php
use backend\components\helpers\Formatter;
use backend\models\db\UserMeta;
use yii\bootstrap\Html;
use yii\helpers\Url;
use yii\grid\GridView;
use yii\widgets\DetailView;
use yii\widgets\Pjax;
use dmstr\bootstrap\Tabs;
use backend\widgets\FormattedTitle;
?>
<div id="body" class="container-fluid" data-select-menu="li#admin-users" data-page-title="<?= FormattedTitle::widget( [ 'title' => $this->title ] ); ?>">
    <div class="row">
        <div class="col-md-12">
            <!-- menu buttons -->
            <p class='pull-left'>
                <?= Html::a(
                    '<span class="glyphicon glyphicon-pencil"></span> Update User',
                    null,
                    [
                        'class' => 'btn btn-info open-modal',
                        'data' => [
                            'modal-url' => Url::toRoute(['update', 'id' => $model->id])
                        ]
                    ]
                ); ?>
            </p>

            <p class="pull-right">
                <?= Html::a('<span class="glyphicon glyphicon-list"></span> ' . 'List Users', ['index'],
                    ['class' => 'btn btn-default']) ?>
            </p>

            <div class="clearfix"></div>

            <!-- flash message -->
            <?php if (\Yii::$app->session->getFlash('deleteError') !== null) : ?>
            <span class="alert alert-info alert-dismissible" role="alert">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
                <?= \Yii::$app->session->getFlash('deleteError') ?>
            </span>
            <?php endif; ?>

            <div class="panel panel-default">
                <div class="panel-body">


                    <?php $this->beginBlock('backend\models\db\User'); ?>

                    <?= DetailView::widget([
                        'model' => $model,
                        'attributes' => [
                            [
                                'format' => 'html',
                                'attribute' => 'user_role_id',
                                'value' => $model->getUserRole()->one() ? Html::a($model->getUserRole()->one()->name, [
                                                'user-role/view',
                                                'id' => $model->getUserRole()->one()->id,
                                            ]) : '<span class="label label-warning">?</span>',
                            ],
                            'username',
                            [
                                'label' => 'Full Name',
                                'value' => $model->getFullName()
                            ],
                            'email:email',
                            [
                                'format' => 'html',
                                'label' => 'Coach',
                                'value' => isset($model->userParent) && isset($model->userParent->userParent) ?
                                    Html::a($model->userParent->userParent->fullName, [
                                        '/admin/user/view',
                                        'id' => $model->userParent->user_parent_id
                                    ]) : ''
                            ],
                            [
                                'label' => $model->getAttributeLabel('created_at'),
                                'value' => Formatter::datetime($model->created_at)
                            ],
                            [
                                'label' => $model->getAttributeLabel('updated_at'),
                                'value' => Formatter::datetime($model->updated_at)
                            ],
                            'archived:boolean',
                        ],
                    ]); ?>

                    <hr/>

                    <?php if ($model->archived) { ?>
                    <a class="btn btn-success open-modal" data-modal-url="<?= Url::toRoute(['activate', 'id' => $model->id]) ?>">
                        <i class="glyphicon glyphicon-off"></i> Activate
                    </a>
                    <?php } else { ?>
                    <a class="btn btn-danger open-modal" data-modal-url="<?= Url::toRoute(['delete', 'id' => $model->id]) ?>">
                        <i class="glyphicon glyphicon-trash"></i> Archive
                    </a>
                    <?php } ?>
                    <?php $this->endBlock(); ?>



                    <?php $this->beginBlock('UserLogins'); ?>
                    <?php Pjax::begin([
                        'id' => 'pjax-UserLogins',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-UserLogins ul.pagination a, th a',
                        //'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>
                    <?= '<div class="table-responsive">' . \yii\grid\GridView::widget([
                        'layout' => '{summary}{pager}<br/>{items}{pager}',
                        'dataProvider' => new \yii\data\ActiveDataProvider([
                            'query' => $model->getUserLogins()->addOrderBy(['time' => SORT_DESC]),
                            'pagination' => ['pageSize' => 20, 'pageParam' => 'page-userlogins']
                        ]),
                        'pager' => [
                            'class' => yii\widgets\LinkPager::className(),
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last'
                        ],
                        'columns' => [
                            [
                                'label' => 'Date',
                                'value' => function($model) {
                                    return Formatter::date($model->time);
                                }
                            ],
                            [
                                'label' => 'Time',
                                'value' => function($model) {
                                    return Formatter::time($model->time);
                                }
                            ],
                            [
                                'label' => 'Period logged in',
                                'value' => function($model) {
                                    return Formatter::period($model->duration);
                                }
                            ],
                        ],
                    ]) . '</div>' ?>
                    <?php Pjax::end() ?>
                    <?php $this->endBlock() ?>


                    <?php $this->beginBlock('UserMetas'); ?>
                    <?php Pjax::begin([
                        'id' => 'pjax-UserMetas',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-UserMetas ul.pagination a, th a',
                        //'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>
                    <?= '<div class="table-responsive">' . \yii\grid\GridView::widget([
                        'layout' => '{pager}<br/>{items}{pager}{summary}',
                        'dataProvider' => new \yii\data\ActiveDataProvider([
                            'query' => $model->getUserMetas()->orderBy('key asc'),
                            'pagination' => ['pageSize' => 20, 'pageParam' => 'page-usermetas']
                        ]),
                        'pager' => [
                            'class' => yii\widgets\LinkPager::className(),
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last'
                        ],
                        'columns' => [
                            /*[
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{view} {update}',
                                'contentOptions' => ['nowrap' => 'nowrap'],
                                'urlCreator' => function ($action, $model, $key, $index) {
                                    // using the column name as key, not mapping to 'id' like the standard generator
                                    $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                    $params[0] = 'user-meta' . '/' . $action;

                                    return $params;
                                },
                                'buttons' => [

                                ],
                                'controller' => 'user-meta'
                            ],
                            'id',*/
                            [
                                'attribute' => 'key',
                                'value' => function ($m) {
                                    return $m->getKeyLabel();
                                }
                            ],
                            'value',
                            'visible:boolean',
                        ]
                    ]) . '</div>' ?>
                    <?php Pjax::end() ?>
                    <?php $this->endBlock() ?>


                    <?php $this->beginBlock('UserPlans'); ?>
                    <div class="clearfix">
                        <?= Html::a(
                            '+ User Plan',
                            null,
                            [
                                'class' => 'btn btn-primary btn-sm open-modal pull-right',
                                'data' => [
                                    'modal-url' => Url::toRoute(['/admin/user-plan/create', 'user_id' => $model->id])
                                ]
                            ]
                        ); ?>
                    </div><?php Pjax::begin([
                        'id' => 'pjax-UserPlans',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-UserPlans ul.pagination a, th a',
                        //'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>
                    <?= '<div class="table-responsive">' . \yii\grid\GridView::widget([
                        'layout' => '{pager}<br/>{items}{pager}{summary}',
                        'dataProvider' => new \yii\data\ActiveDataProvider([
                            'query' => $model->getUserPlans()->addOrderBy(['start_time' => SORT_DESC]),
                            'pagination' => ['pageSize' => 20, 'pageParam' => 'page-userplans']
                        ]),
                        'pager' => [
                            'class' => yii\widgets\LinkPager::className(),
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last'
                        ],
                        'columns' => [
                            /*[
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{update}',
                                'contentOptions' => ['nowrap' => 'nowrap'],
                                'urlCreator' => function ($action, $model, $key, $index) {
                                    // using the column name as key, not mapping to 'id' like the standard generator
                                    $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                    $params[0] = 'user-plan' . '/' . $action;

                                    return $params;
                                },
                                'buttons' => [

                                ],
                                'controller' => 'user-plan'
                            ],*/
                            [
                                'class' => yii\grid\DataColumn::className(),
                                'attribute' => 'user_plan_type_id',
                                'value' => function ($model) {
                                    if ($rel = $model->getUserPlanType()->one()) {
                                        return Html::a($rel->name, ['user-plan-type/view', 'id' => $rel->id,],
                                            ['data-pjax' => 0]);
                                    } else {
                                        return '';
                                    }
                                },
                                'format' => 'raw',
                            ],
                            [
                                'label' => $model->getAttributeLabel('start_time'),
                                'value' => function($model) {
                                    return Formatter::datetime($model->start_time);
                                }
                            ],
                            [
                                'label' => $model->getAttributeLabel('expirationTime'),
                                'value' => function($model) {
                                    return Formatter::datetime($model->expirationTime);
                                }
                            ],
                            'status:raw',
                            [
                                'label' => 'Action',
                                'value' => function ($model) {
                                    if ($model->status == 'Active' && !$model->is_cancelled && !empty($model->stripe_subscription_id)) {
                                        return Html::a('Cancel Subscription', ['user/cancel', 'id' => $model->id], ['onclick' => "return confirm('Are you sure?')"]);
                                    }
                                    else {
                                        return '';
                                    }
                                },
                                'format' => 'raw',
                            ]
                        ]
                    ]) . '</div>' ?>
                    <?php Pjax::end() ?>
                    <?php $this->endBlock() ?>


                    <?php $this->beginBlock('UserRegistrations'); ?>
                    <?php /*<div style='position: relative'>
                        <div style='position:absolute; right: 0px; top 0px;'>
                            <?= Html::a(
                                '<span class="glyphicon glyphicon-list"></span> ' . 'List All' . ' User Registrations',
                                ['user-registration/index'],
                                ['class' => 'btn text-muted btn-xs']
                            ) ?>
                            <?= Html::a(
                                '<span class="glyphicon glyphicon-plus"></span> ' . 'New' . ' User Registration',
                                ['user-registration/create', 'UserRegistration' => ['user_id' => $model->id]],
                                ['class' => 'btn btn-success btn-xs']
                            ); ?>
                        </div>
                    </div><?php*/ Pjax::begin([
                        'id' => 'pjax-UserRegistrations',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-UserRegistrations ul.pagination a, th a',
                        //'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>
                    <?= '<div class="table-responsive">' . \yii\grid\GridView::widget([
                        'layout' => '{pager}<br/>{items}{pager}{summary}',
                        'dataProvider' => new \yii\data\ActiveDataProvider([
                            'query' => $model->getUserRegistrations()->addOrderBy(['time' => SORT_DESC]),
                            'pagination' => ['pageSize' => 20, 'pageParam' => 'page-userregistrations']
                        ]),
                        'pager' => [
                            'class' => yii\widgets\LinkPager::className(),
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last'
                        ],
                        'columns' => [
                            /*[
                                'class' => 'yii\grid\ActionColumn',
                                'template' => '{view} {update}',
                                'contentOptions' => ['nowrap' => 'nowrap'],
                                'urlCreator' => function ($action, $model, $key, $index) {
                                    // using the column name as key, not mapping to 'id' like the standard generator
                                    $params = is_array($key) ? $key : [$model->primaryKey()[0] => (string)$key];
                                    $params[0] = 'user-registration' . '/' . $action;

                                    return $params;
                                },
                                'buttons' => [

                                ],
                                'controller' => 'user-registration'
                            ],*/
                            [
                                'label' => 'Registration Time',
                                'value' => function($model) {
                                    return Formatter::datetime($model->time);
                                }
                            ],
                            /*[
                                'label' => $model->getAttributeLabel('auth_time'),
                                'value' => function($model) {
                                    return Formatter::datetime($model->auth_time);
                                }
                            ],*/
                        ]
                    ]) . '</div>' ?>
                    <?php Pjax::end() ?>
                    <?php $this->endBlock() ?>


                    <?php $this->beginBlock('UserChildren'); ?>
                    <?php Pjax::begin([
                        'id' => 'pjax-UserChildren',
                        'enableReplaceState' => false,
                        'linkSelector' => '#pjax-UserChildren ul.pagination a, th a',
                        //'clientOptions' => ['pjax:success' => 'function(){alert("yo")}']
                    ]) ?>
                    <?= '<div class="table-responsive">' . \yii\grid\GridView::widget([
                        'layout' => '{pager}<br/>{items}{pager}{summary}',
                        'dataProvider' => new \yii\data\ActiveDataProvider([
                            'query' => $model->getUserChildren()->addOrderBy(['time' => SORT_DESC]),
                            'pagination' => ['pageSize' => 20, 'pageParam' => 'page-userchildren']
                        ]),
                        'pager' => [
                            'class' => yii\widgets\LinkPager::className(),
                            'firstPageLabel' => 'First',
                            'lastPageLabel' => 'Last'
                        ],
                        'columns' => [
                            [
                                'label' => UserMeta::METAKEYS[UserMeta::FIRST_NAME],
                                'value' => function($model) {
                                    return $model->user->getMetaValueByKey(UserMeta::FIRST_NAME);
                                }
                            ],
                            [
                                'label' => UserMeta::METAKEYS[UserMeta::LAST_NAME],
                                'value' => function($model) {
                                    return $model->user->getMetaValueByKey(UserMeta::LAST_NAME);
                                }
                            ],
                            [
                                'label' => $model->getAttributeLabel('username'),
                                'value' => function($model) {
                                    return $model->user->username;
                                }
                            ],
                            [
                                'label' => $model->getAttributeLabel('email'),
                                'value' => function($model) {
                                    return $model->user->email;
                                }
                            ],
                            [
                                'label' => $model->getAttributeLabel('created_at'),
                                'value' => function($model) {
                                    return Formatter::datetime($model->user->created_at);
                                }
                            ],
                        ]
                    ]) . '</div>' ?>
                    <?php Pjax::end() ?>
                    <?php $this->endBlock() ?>


                    <?= Tabs::widget(
                        [
                            'id' => 'relation-tabs',
                            'encodeLabels' => false,
                            'items' => [
                                [
                                    'label' => '<b class="">User Info</b>',
                                    'content' => $this->blocks['backend\models\db\User'],
                                    'active' => true,
                                ],
                                [
                                    'content' => $this->blocks['UserMetas'],
                                    'label' => '<small>Account Information</span></small>',
                                    'active' => false,
                                ],
                                [
                                    'content' => $this->blocks['UserLogins'],
                                    'label' => '<small>User Logins <span class="badge badge-default">' . $model->getUserLogins()->count() . '</span></small>',
                                    'active' => false,
                                ],
                                [
                                    'content' => $this->blocks['UserPlans'],
                                    'label' => '<small>User Plans <span class="badge badge-default">' . $model->getUserPlans()->count() . '</span></small>',
                                    'active' => false,
                                ],
                                [
                                    'content' => $this->blocks['UserRegistrations'],
                                    'label' => '<small>User Registrations <span class="badge badge-default">' . $model->getUserRegistrations()->count() . '</span></small>',
                                    'active' => false,
                                ],
                                [
                                    'content' => $this->blocks['UserChildren'],
                                    'label' => '<small>Sub Accounts <span class="badge badge-default">' . $model->getUserChildren()->count() . '</span></small>',
                                    'active' => false,
                                ],
                            ]
                        ]
                    );
                    ?>
                </div>
            </div>
        </div>
    </div>
</div>
