<?php

namespace backend\modules\api\components;

use backend\models\db\User;
use Yii;
use yii\filters\AccessControl;
use yii\filters\auth\HttpBasicAuth;
use yii\rest\ActiveController;


class AuthController extends ActiveController
{
    public function behaviors()
    {
        $behaviors = parent::behaviors();
        $behaviors['authenticator'] = [
            'class' => HttpBasicAuth::className(),
            'auth' => function ($username, $password) {
                $user = User::authenticate($username, $password);
                Yii::error('AUTH RESULT: ' . $username . ' = ' . print_r($user, true));
                $this->trackLogin($user);
                return is_object($user) ? $user : null;
            }
        ];
        $behaviors['access'] = [
            'class' => AccessControl::className(),
            'rules' => [
                [
                    'allow' => true,
                    'roles' => ['@'],
                ]
            ],
        ];
        return $behaviors;
    }

    public function init()
    {
        parent::init();
        Yii::error('AUTH INIT: ' . print_r(Yii::$app->request->headers->toArray(), true));
        Yii::$app->user->loginUrl = null;
        Yii::$app->user->enableSession = false;
        Yii::$app->response->format = 'json';
    }

    protected function trackLogin($user)
    {
        if (is_object($user)) {
            $key = 'lastActivityTime-' . $user->id;
            $activityTime = Yii::$app->cache->get($key);
            $user->trackLogin(
                $activityTime,
                $user->userRole->name,
                $user->id
            );
            Yii::$app->cache->set($key, time());
        }
    }
}