<?php

namespace backend\modules\api\components;

use backend\models\db\Account;
use backend\models\db\Expense;
use backend\models\db\Transfer;
use backend\models\db\TransferEvent;
use backend\models\db\User;
use Yii;
use yii\rest\Action;
use yii\web\ServerErrorHttpException;


class CreateTransfer extends Action
{
    public $scenario = 'api';
    protected $userId;


    public function run()
    {
        if ($this->checkAccess) {
            call_user_func($this->checkAccess, $this->id);
        }
        Yii::warning(print_r(Yii::$app->getRequest()->getBodyParams(), true));
        $this->userId = Yii::$app->session->get('mainUserId');

        $transfer = new Transfer([
            'scenario' => $this->scenario,
        ]);
        $transfer->load(Yii::$app->getRequest()->getBodyParams(), '');
        if (!$transfer->validate()) {
            return $transfer;
        }
        $transferEvent = new TransferEvent([
            'scenario' => $this->scenario
        ]);
        $transferEvent->load(Yii::$app->getRequest()->getBodyParams(), '');
        if (!$transferEvent->validate()) {
            return $transferEvent;
        }

        $fromAccount = Account::find()
            ->joinWith('budget')
            ->where([
                Account::tableName() . '.id' => $transfer->account_from_id,
                'user_id' => $this->userId
            ])
            ->exists();
        if (!$fromAccount) {
            $transfer->addError('account_from_id', 'Invalid "from" account selected.');
            return $transfer;
        }
        $toAccount = Account::find()
            ->joinWith('budget')
            ->where([
                Account::tableName() . '.id' => $transfer->account_to_id,
                'user_id' => $this->userId
            ])
            ->exists();
        if (!$toAccount) {
            $transfer->addError('account_to_id', 'Invalid "to" account selected.');
            return $transfer;
        }

        $transfer->budget_id = User::findOne($this->userId)->getActiveBudgetId($this->userId);

        if ($transfer->save()) {
            // for past dates the event is created automatically
            if ($transfer->date > date('Y-m-d')) {
                $transferEvent->transfer_id = $transfer->id;
                if ($transferEvent->save()) {
                    $response = Yii::$app->getResponse();
                    $response->setStatusCode(201);
                    return $transfer;
                }
            }
            else {
                return $transfer;
            }
        }
        if (!$transfer->hasErrors() && !$transferEvent->hasErrors()) {
            throw new ServerErrorHttpException('Failed to create the object for unknown reason.');
        }
        return $transfer->hasErrors() ? $transfer : $transferEvent;
    }
}