<?php

namespace backend\modules\api\controllers;

use backend\modules\api\components\AuthController;
use Yii;

/**
 * ExpenseTransaction controller for the `api` module
 */
class ExpenseTransactionController extends AuthController
{
    public $modelClass = 'backend\models\db\Transaction';
    public $defaultAction = 'create';
    public $createScenario = 'create';


    /**
     * @inheritdoc
     */
    public function actions()
    {
        // we leave only view and update actions
        $actions = parent::actions();
        unset($actions['index']);
        unset($actions['view']);
        unset($actions['delete']);
        unset($actions['update']);
        unset($actions['options']);
        $actions['create'] = [
            'class' => 'backend\modules\api\components\CreateTransaction',
            'modelClass' => $this->modelClass
        ];
        return $actions;
    }
}
