<?php

namespace backend\modules\api\controllers;

use backend\models\db\Budget;
use backend\models\db\Jar;
use backend\modules\api\components\AuthController;
use Yii;

/**
 * User controller for the `api` module
 */
class JarController extends AuthController
{
    public $modelClass = 'backend\models\db\Jar';
    public $defaultAction = 'index';


    /**
     * @inheritdoc
     */
    public function actions()
    {
        // we leave only index action
        $actions = parent::actions();
        unset($actions['create']);
        unset($actions['view']);
        unset($actions['delete']);
        unset($actions['update']);
        unset($actions['options']);
        return $actions;
    }

    public function actionIndex()
    {
        return Jar::find()
            ->joinWith('budget')
            ->where([
                'is_mock' => 0,
                Budget::tableName() . '.archived' => 0,
                Jar::tableName() . '.archived' => 0,
                'user_id' => Yii::$app->session->get('mainUserId')
            ])
            ->orderBy('order ASC')
            ->all();
    }
}
