<?php

namespace backend\modules\api\controllers;

use backend\models\db\Account;
use backend\models\db\Budget;
use backend\models\db\Expense;
use backend\models\db\Income;
use backend\models\db\Transfer;
use backend\models\db\User;
use backend\modules\api\components\AuthController;
use Yii;
use yii\filters\AccessControl;
use yii\filters\auth\HttpBasicAuth;
use yii\helpers\ArrayHelper;
use yii\rest\ActiveController;
use yii\web\NotFoundHttpException;

/**
 * User controller for the `api` module
 */
class UserController extends AuthController
{
    public $modelClass = 'backend\models\db\User';
    public $defaultAction = 'view';


    /**
     * @inheritdoc
     */
    public function actions()
    {
        // we leave only view and update actions
        $actions = parent::actions();
        unset($actions['create']);
        unset($actions['index']);
        unset($actions['view']);
        unset($actions['delete']);
        unset($actions['options']);
        return $actions;
    }

    public function actionView()
    {
        /** @var User $user */
        $user     = Yii::$app->user->identity;
        $budgetId = $user->getActiveBudgetId($user->getMainUserId());
        $budget   = Budget::findOne($budgetId);
        if (!$user || !$budget) {
            throw new NotFoundHttpException('User not found.');
        }

        $accounts = Account::getAccountsList($budgetId);
        $jars     = $budget->getActiveJars();
        $jarIds   = ArrayHelper::map($jars, 'id', 'id');
        $from     = date('Y-m-d', strtotime('-30 days'));
        $to       = date('Y-m-d');

        return [
            'user' => $user,
            'jars' => $jars,
            'accounts' => $accounts,
            'incomes' => Income::getIncomesForTransaction($budgetId, $jarIds, true),
            'expenses' => Expense::getExpensesForTransaction($jarIds, false, true),
            'transfers' => Transfer::getTransfersList($budgetId),
            'transactions' => [
                'incomes' => $budget->getTimePeriodIncomeTransactions($from, $to),
                'expenses' => $budget->getTimePeriodExpenseTransactions($from, $to),
                'transfers' => $budget->getTimePeriodTransferEvents($from, $to)
            ]
        ];
    }
}
