<?php
use backend\components\helpers\JsTools;
use backend\models\db\Account;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\widgets\VideoTutorial;

/** @var Account $account */
?>

<?php if (isset($isMockBudget) && $isMockBudget) { ?>
<div id="body" class="container-fluid secondary-nav is-mock-budget" data-js-callback="accountDetailLoaded" data-select-menu="li#my-financials-accounts" data-account-id="<?= $account->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-mock-budget-id="<?= $budgetId ?>">
<?php } else { ?>
<div id="body" class="container-fluid secondary-nav" data-js-callback="accountDetailLoaded" data-select-menu="li#my-financials-accounts" data-account-id="<?= $account->id ?>" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
<?php } ?>
    <?= VideoTutorial::widget(['type' => 'accounts']) ?>
    <?php if (isset($isMockBudget) && $isMockBudget) {
        echo $this->render('/mock-budgets/_mock-budget-header', [
            'budgetId' => $budgetId,
            'budgetName' => $budgetName,
            'pageTitle' => 'Accounts',
        ]);
    } ?>
    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3 class="account-name"><?= $account->name ?></h3>
                <?php if ($allowEdit) { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/accounts/edit-account', 'id' => $account->id]) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                <a href="#" class="open-modal delete-btn" data-modal-url="<?= Url::toRoute(['/accounts/remove-account', 'id' => $account->id]) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                <?php } else { ?>
                <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/accounts/restore-account', 'id' => $account->id]) ?>" data-toggle="tooltip" title="Restore"><i class="glyphicon glyphicon-refresh gi-2x"></i></a>
                <?php } ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-5 col-sm-12">
            <div class="panel">
                <div class="label-group">
                    <label>Current Balance</label>
                    <div class="label-value account-current-balance">
                        <?= Formatter::currency($account->getCurrentBalance()); ?>
                    </div>
                </div>
                <div class="label-group">
                    <label>Type of Account</label>
                    <div class="label-value">
                        <?= $account->getAccountType()->one()->name; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-md-7 col-sm-12">
            <div class="panel panel-paged">
                <?= $this->render('/account-balances/_account-balances-graph', [
                    'account' => $account,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-5">
            <div class="col-head">
                <h4>Balance Sheet</h4>
            </div>
        </div>
        <div class="col-sm-3">
            <div class="input-group">
                <?= \dosamigos\datetimepicker\DateTimePicker::widget([
                    'name' => 'bs_start',
                    'value' => Formatter::date(strtotime('-30 days')),
                    'template' => '{input}{button}',
                    'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                    'clientOptions' => [
                        'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                        'minView' => 'month',
                        'maxView' => 'year',
                        'autoclose' => true
                    ]
                ]) ?>
            </div>
        </div>
        <div class="col-sm-1 text-center search-vertical-align">
            to
        </div>
        <div class="col-sm-3">
            <div class="input-group">
                <?= \dosamigos\datetimepicker\DateTimePicker::widget([
                    'name' => 'bs_end',
                    'value' => Formatter::date(time()),
                    'template' => '{input}{button}',
                    'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                    'clientOptions' => [
                        'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                        'minView' => 'month',
                        'maxView' => 'year',
                        'autoclose' => true
                    ]
                ]) ?>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="panel panel-table transactions-panel">
                <?= $this->render('/accounts/_balance-sheet-table', [
                    'account' => $account,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-7">
            <div class="col-head">
                <h4>Expenses</h4>
            </div>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="e-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="panel panel-table transactions-panel">
                <?= $this->render('/money-operations/_account-expense-transactions-table', [
                    'account' => $account,
                    'ajaxUrl' => Url::toRoute(['/money-operations/account-expense-transactions-table', 'account_id' => $account->id]),
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-7">
            <div class="col-head">
                <h4>Incomes</h4>
            </div>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="it-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="panel panel-table transactions-panel">
                <?= $this->render('/income-transactions/_account-income-transactions-table', [
                    'account' => $account,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-sm-7">
            <div class="col-head">
                <h4>Transfers</h4>
            </div>
        </div>
        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="tf-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-sm-12">
            <div class="panel panel-table transactions-panel">
                <?= $this->render('/transfer-events/_account-transfer-events-table', [
                    'account' => $account,
                    'allowEdit' => $allowEdit
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
<?= JsTools::viewJs($this); ?>