<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
?>

<!---------------------------------------------------------------
Secondary Navigation
---------------------------------------------------------------->
<?= $this->render('_accounts-list', [
    'budgetId' => $budgetId,
    'accounts' => $accounts,
    'account' => $account,
    'defaultAccountId' => $defaultAccountId,
    'title' => ($allowEdit) ? 'My Accounts' : 'Deleted Accounts',
    'allowEdit' => $allowEdit
]); ?>
<!---------------------------------------------------------------
End Secondary Navigation
---------------------------------------------------------------->

<!---------------------------------------------------------------
Body
---------------------------------------------------------------->
<div class="account-container content-container" data-block-loading="true">

<?= $this->render('account-detail-content', [
    'accounts' => $accounts,
    'account' => $account,
    'allowEdit' => $allowEdit,
    'budgetId' => (isset($budgetId) ? $budgetId : false),
    'budgetName' => (isset($budgetName) ? $budgetName : false),
    'isMockBudget' => (isset($isMockBudget) ? $isMockBudget : false)
]); ?>

</div>
<!---------------------------------------------------------------
End Body
---------------------------------------------------------------->


