<?php
use backend\components\helpers\Formatter;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-account-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Account Name') ?>

    <?= $form->field($formModel, 'balance', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->balance, 'none')
        ]
    ])
        ->label('Current Balance')
        ->hint('Negative balances (i.e. overdraft) should be entered as a negative figure.')
    ?>

    <?=
    $form->field($formModel, 'is_central_account')->checkbox([
        'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
    ])->label('Make this the "Central Account?"');
    ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Add Account', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => JsTools::jsCallback($this, 'reloadAccountsAfterAdd'),
        'data-submit-url' => Url::toRoute(['/accounts/add-account', 'budget_id' => (isset($budgetId) ? $budgetId : false)])
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


