<?php
use backend\components\helpers\Formatter;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'edit-account-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Account Name') ?>

    <?php if ($adjustable) {
        echo $form->field($formModel, 'balance', [
                'inputOptions' => [
                    'value' => Formatter::currency($formModel->balance, 'none')
                ]
            ])
            ->label('Last Month End-balance')
            ->hint('Negative balances (i.e. overdraft) should be entered as a negative figure.');
        }
        else { ?>
    <div class="form-group">
        <label>Last Month End-balance</label>
        <p>
            <em>
                To edit the account balance, please do so on your End of Month Summary.<br/>
                Use the "Resubmit EoMS" button if you have already submitted it.
            </em>
        </p>
        <?= $form->field($formModel, 'balance', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
    </div>
    <?php } ?>

    <?=
    $form->field($formModel, 'is_debt_active', [
        'options' => [
            'class' => 'form-group',
            'style' => $formModel->account_type_id != 2 ? 'display:none' : ''
        ]
    ])->checkbox([
        'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
    ])->label($formModel->account_type_id != 2 ? 'This Debt is active' : 'This Credit Card is active');
    ?>

    <?= $isDefaultAccount ?
        '<div class="form-group">
            <p>
                <strong>This account is the central account</strong>
            </p>
        </div>' :
        $form->field($formModel, 'is_central_account')->checkbox([
            'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
        ])->label('Make this the "Central Account?"');
    ?>

</div>
<div class="modal-footer">
    <?php if (!isset($noClose) || (!$noClose)) {?>
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?php } ?>
    <?= Html::submitButton('Save Account', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => JsTools::jsCallback($this, 'reloadAccountsAfterEdit'),
        'data-submit-url' => Url::toRoute(['/accounts/edit-account', 'id' => $accountId])
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


