<?php
use backend\components\helpers\Formatter;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'edit-cc-account-form']); ?>
<div class="modal-body">
    <div class="message"></div>

    <?= $form->field($formModel, 'name')->label('Account Name') ?>

    <?php if ($adjustable) {
            echo $form->field($formModel, 'balance', [
                'inputOptions' => [
                    'value' => Formatter::currency($formModel->balance, 'none')
                ]
            ])
            ->label('Current Balance<br/><em>Negative balances (i.e. money owing on your credit card) should be entered as a negative value.</em>');
        }
        else { ?>
    <div class="form-group">
        <label>Last Month End-balance</label>
        <p>
            <em>
                To edit the account balance, please do so on your End of Month Summary.<br/>
                Use the "Resubmit EoMS" button if you have already submitted it.
            </em>
        </p>
        <?= $form->field($formModel, 'balance', ['options' => ['class' => 'hidden']])->hiddenInput() ?>
    </div>
    <?php } ?>

    <?= $form->field($formModel, 'account_type_id', [
        'options' => ['class' => 'hidden']
    ])->hiddenInput(); ?>

    <?=
    $form->field($formModel, 'is_debt_active', [
        'options' => [
            'class' => 'form-group'
        ]
    ])->checkbox([
        'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
    ])->label(
        ($formModel->account_type_id != 2 ? 'This Debt is active' : 'This Credit Card is active') . '<br/>' .
        '<em>' . ($formModel->account_type_id != 2 ? 'A debt' : 'A credit card') .
            " is only 'Active' if it is both a debt and a source of funding to buy stuff ie an active credit card, a Line of Credit, redraw facility, etc." .
        '</em>'
    );
    ?>

    <?=
    $form->field($formModel, 'payment', [
        'inputOptions' => [
            'value' => Formatter::currency($formModel->payment, 'none')
        ]
    ])
        ->label('Current Payment')
        ->hint('Current payment is the amount you are actually paying off your loan, this is often more than the required ‘minimum payment’. If your current payment on this loan is the minimum, just enter the minimum payment figure.')
    ?>

    <?=
    $form->field($formModel, 'frequency')
        ->dropDownList($frequencies, ['prompt' => 'Select one'])
        ->label('Payment Frequency')
    ?>

    <?=
    $form->field($formModel, 'interest')
        ->label('Interest Rate on Loan %')
        ->hint('The interest rate you are currently paying on your loan should be found on your most recent loan statement.')
    ?>

    <?=
    $form->field($formModel, 'formattedDate')->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('Next Payment Date')
    ?>

    <?=
    $form->field($formModel, 'account_id')
        ->dropDownList($accounts, ['prompt' => 'Select one'])
        ->label('Account')
        ->hint('Account is the bank account from which the repayments are deducted.')
    ?>

    <?=
    $form->field($formModel, 'has_interest_free_period')
        ->checkbox(['template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"])
        ->label('Has an Interest Free Period')
        ->hint('If you loan has an interest free period, tick this box and enter the date that this interest free period ends. It is very important that you keep track of this date to ensure you avoid potential heavy interest penalties when the interest period ends.')
    ?>

    <?=
    $form->field($formModel, 'formattedInterestFreeEndDate', ['options' => ['class' => 'form-group hidden']])->widget(\dosamigos\datetimepicker\DateTimePicker::className(), [
        'template' => '{input}{button}',
        'pickButtonIcon' => 'glyphicon glyphicon-calendar',
        'clientOptions' => [
            'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
            'minView' => 'month',
            'maxView' => 'year',
            'autoclose' => true
        ]
    ])->label('End of Interest Free Period')
    ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Save Account', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => JsTools::jsCallback($this, 'reloadAccountsAfterEdit'),
        'data-submit-url' => Url::toRoute(['/accounts/edit-account', 'id' => $accountId])
    ]) ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


