<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
?>

<div id="body" class="container-fluid" data-js-callback="bodyLoaded" data-select-menu="li.activity-log" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">

    <div class="row">
        <div class="col-md-12">
            <div class="col-head">
                <h3>Activity Log</h3>
            </div>
        </div>
    </div>

    <?php if (Yii::$app->user->isSuperAdmin) { ?>
    <p>
        <strong><?= Html::a('Download CSV with search logs', Url::to(['/activity-log/search-log']), ['class' => 'skip-history']) ?></strong>
    </p>
    <?php } ?>

    <div class="row mb mt20">
        <div class="col-sm-4">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="al-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table">
                <?= $this->render('_activity-log-table'); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>
