<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
use backend\widgets\Tooltip;
?>

<h4>
    Surplus/Deficit
    <?=
        Tooltip::widget(['text' => 'This is your moment of truth, here you compare what you actually have in your bank accounts verses what your budget says you actually need to cover your future expenses']);
    ?>
</h4>
<div class="panel budget-calc eoms-summary">
    <table class="table">
        <tbody>
        <tr>
            <td>
                <div class="item-value">
                    <div class="value accounts-eoms-balance"><?= Formatter::currency($accountsEomsBalance) ?></div>
                    <div class="desc">
                        Bank Balance
                        <?=
                            Tooltip::widget(['text' => 'Bank Balances is the sum of the Bank balances you identified as ‘Amount to Use for Summary’']);
                        ?>
                    </div>
                </div>
            </td>
            <td class="text-center"><span class="minus mr">-</span><span class="bracket">(</span></td>
            <td>
                <?php if ($eoms->cc_pay_off_option == \backend\models\db\Eoms::CC_PAY_OFF_NOT_EVERY_MONTH) { ?>
                <div class="item-value">
                    <div class="value cc-debt-transactions-amount"><?= Formatter::currency($ccDebtTransactionsAmount) ?></div>
                    <div class="desc">
                        This Months Credit Card Spending
                        <?=
                            Tooltip::widget(['text' => 'This month’s Credit Card spending is the difference between ‘Last months balance’ and this month’s ‘Actual Balance’. We need to have the funds available in our Bank accounts to cover credit cards purchases made over the past month.']);
                        ?>
                    </div>
                </div>
                <?php } else { ?>
                <div class="item-value">
                    <div class="value cc-debt-transactions-amount"><?= Formatter::currency($ccActualBalanceTotal) ?></div>
                    <div class="desc">
                        Balance Owing on Credit Cards
                        <?=
                        Tooltip::widget(['text' => 'Balance Owing on Credit Cards is the sum of Actual Balance of all your active credit cards.']);
                        ?>
                    </div>
                </div>
                <?php } ?>
            </td>
            <td class="text-center"><span class="plus">+</span></td>
            <td>
                <div class="item-value">
                    <div class="value next-months-everyday-amount">
                        <?php if ($editable) {
                            echo $form->field($eForm, 'amount', [
                                'template' => "{input}\n<span class=\"form-control-feedback\" aria-hidden=\"true\">" . Formatter::getCurrencySign() . "</span>\n{hint}\n{error}",
                                'options' => [
                                    'class' => 'form-group has-feedback'
                                ]
                            ])->textInput([
                                'value' => Formatter::currency($eForm->amount, 'none'),
                                'class' => 'form-control currency-field'
                            ])->label('');
                        }
                        else {
                            echo Formatter::currency($nextMonthsEverydayAmount);
                        } ?>
                    </div>
                    <div class="desc">
                        Next Months Everyday Expenses
                        <?=
                            Tooltip::widget(['text' => 'One of the most powerful tools we recommend to our clients is to isolate the money allocated to their ‘Everyday Jar’ into a separate ‘Everyday Account’ on the first day of each month. To ensure this money is available to be transferred we include it in the End of Month Summary calculation.']);
                        ?>
                    </div>
                </div>
            </td>
            <td class="text-center"><span class="plus">+</span></td>
            <td>
                <div class="item-value">
                    <div class="value remaining-jar-amount"><?= Formatter::currency($remainingJarAmount) ?></div>
                    <div class="desc">
                        Jar Funds Remaining
                        <?=
                            Tooltip::widget(['text' => 'Jars Funds remaining is the sum total of accumulated funds in all your Jars at the end of the month. We need to make sure that the money our Budget says we have available to spend in our Jars is backed up by real money in the Bank.']);
                        ?>
                    </div>
                </div>
            </td>
            <td class="text-center"><span class="bracket mr">)</span><span class="bracket">=</span></td>
            <td>
                <div class="item-value">
                    <div class="value<?= $equationResult > 0 ? ' value-green' : ($equationResult < 0 ? ' value-red' : '') ?> equation-result"><?= Formatter::currency($equationResult) ?></div>
                    <div class="desc">
                        <?= ($equationResult >=0) ? 'Surplus' : 'Deficit'; ?>
                    </div>
                </div>
            </td>
        </tr>
        </tbody>
    </table>
</div>
