<?php
use backend\components\ActiveForm;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
use yii\helpers\Html;
use yii\helpers\Url;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'adjust-jar-funds-remaining-form']); ?>
<div class="modal-body">
    <div class="message"></div>
    <?= $form->field($formModel, 'jar_id')->dropDownList($jarsList, [
        $jar->name => ['selected' => true]
    ])->label('Jar'); ?>

    <?= $form->field($formModel, 'year')->dropDownList($years, [
        $year => ['selected' => true]
    ]); ?>

    <?= $form->field($formModel, 'month')->dropDownList($months, [
        $month => ['selected' => true]
    ]); ?>

    <?= $form->field($formModel, 'funds_remaining_current', [
        'inputOptions' => [
            'readonly' => true,
            'value' => Formatter::currency($formModel->funds_remaining_current, 'none')
        ]
    ])->label('Current Funds Remaining') ?>

    <?= $form->field($formModel, 'funds_remaining_adjustment')->label('New Funds Remaining') ?>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Update', [
        'class' => 'btn btn-primary ajax-submit',
        'data-js-callback' => JsTools::jsCallback($this, 'reloadJarSummary'),
        'data-submit-url' => Url::toRoute([
            '/budget/adjust-jar-funds-remaining',
            'jar_id' => $formModel->jar_id,
            'month'  => $formModel->month,
            'year'   => $formModel->year
        ])
    ]) ?>
</div>
<script type="application/javascript">
    $(document).ready(function() {
        $('body').on('change', '#adjustjarfundsremaining-jar_id, #adjustjarfundsremaining-year, #adjustjarfundsremaining-month', function() {
            var form = '#adjust-jar-funds-remaining-form',
                jarId = $('#adjustjarfundsremaining-jar_id').val(),
                month = $('#adjustjarfundsremaining-month').val(),
                year  = $('#adjustjarfundsremaining-year').val();
            if (!month) {
                month = (new Date()).getMonth() + 1;
            }
            $(form).blockloader();
            $.ajax({
                url: '<?= Url::to(['/budget/adjust-jar-funds-remaining']) ?>',
                method: 'get',
                data: {
                    jar_id: jarId,
                    month: month,
                    year: year
                },
                complete: function(result, status) {
                    if (status == 'success') {
                        $(form + ' #adjustjarfundsremaining-month').html($(result.responseText).find('#adjustjarfundsremaining-month').html());
                        $(form + ' #adjustjarfundsremaining-year').html($(result.responseText).find('#adjustjarfundsremaining-year').html());
                        $(form + ' #adjustjarfundsremaining-funds_remaining_current').val($(result.responseText).find('#adjustjarfundsremaining-funds_remaining_current').val());
                        $(form + ' #adjustjarfundsremaining-month').val(month);
                        $(form + ' #adjustjarfundsremaining-year').val(year);
                    }
                    $(form).blockloader('hide');
                }
            });
        });
    });
</script>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>
