<?php
use backend\components\helpers\Calculator;
use backend\components\helpers\Formatter;
use backend\models\db\TimeSlotBooking;
use dosamigos\datetimepicker\DateTimePicker;
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'add-booking-form']); ?>
<div class="modal-body">

    <div class="message"></div>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($formModel, 'formattedStartDate')->widget(DateTimePicker::className(), [
                'template' => '{input}{button}',
                'pickButtonIcon' => 'glyphicon glyphicon-calendar',
                'clientOptions' => [
                    'format' => Formatter::phpDateCodeToDatepickerCode(Yii::$app->session->get('dateFormat')),
                    'minView' => 'month',
                    'maxView' => 'year',
                    'autoclose' => true
                ]
            ])->label('Start Date/Time') ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($formModel, 'startTime')
                ->dropDownList(Calculator::getTimeOfDayHours())
                ->label('&nbsp;') ?>
        </div>
        <div class="col-md-12">
            Appointment length: <strong><?= TimeSlotBooking::DEFAULT_BOOKING_MINUTES ?> minutes</strong>
        </div>
        <?php if ($model && !$model->canCancelBooking()) { ?>
        <div class="col-md-12">
            <p class="text-danger">To cancel this appointment please contact your coach directly.</p>
        </div>
        <?php } ?>
    </div>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?php if ($edit) {
        if ($model->canCancelBooking()) {
            echo Html::submitButton('Cancel appointment', [
                'class' => 'btn btn-danger open-modal',
                'data-modal-url' => Url::toRoute(['/coach/cancel-booking', 'id' => $edit])
            ]);
        }
        echo Html::submitButton('Update appointment', [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute(['/coach/add-booking', 'id' => $edit])
        ]);
    } else {
        echo Html::submitButton('Book appointment', [
            'class' => 'btn btn-primary ajax-submit',
            'data-js-callback' => 'reloadAppointmentsDay',
            'data-submit-url' => Url::toRoute('/coach/add-booking')
        ]);
    } ?>
</div>
<?php ActiveForm::end(); ?>
<?= JsTools::viewJs($this); ?>


