<?php
use backend\models\db\Budget;
use yii\helpers\Url;
use backend\components\helpers\Formatter;

$id = isset($id) ? $id : 1;

/** @var Budget $budget */
$month = isset($month) ? $month : date('m');
$year  = isset($year) ? $year : date('Y');
?>

<table id="dp-table-<?= $id ?>" class="table table-paginated table-bordered data-table" data-table-id="dp-table-<?= $id ?>" data-ajax="<?= Url::toRoute([
    '/debt-payments/debt-payments-table-full',
    'budget_id' => $budget->id,
    'month' => $month,
    'year' => $year
]); ?>">
    <thead>
        <tr>
            <th class="sort-by sort-desc">Debt</th>
            <th>Amount</th>
            <th>Expense Frequency</th>
            <th>Average Monthly Amount</th>
            <th>Account</th>
            <th>Due Date</th>
            <th class="no-sort"></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="7" class="dataTables_empty">No debts yet.</td>
        </tr>
    </tbody>
    <?php if (!isset($hideSummary) || !$hideSummary) { ?>
    <tfoot>
        <tr>
            <td colspan="6">Total Expenses</td>
            <td class="this-months-jar-debt-payments-amount">
                <?= Formatter::currency($jar->getMonthlyBudget($month, $year)) ?>
            </td>
        </tr>
    </tfoot>
    <?php } ?>
</table>
