<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;
?>

<table id="d-table-1" class="table table-paginated table-bordered data-table" data-table-id="d-table-1" data-ajax="<?= Url::toRoute(['/debts/debts-table', 'js_callback_add' => $jsCallbackAdd, 'js_callback_pause' => $jsCallbackPause, 'budget_id' => isset($budgetId) ? $budgetId : false]) ?>">
    <thead>
        <tr>
            <th>Name</th>
            <th>Type of Debt</th>
            <th>Interest Rate</th>
            <th>Interest Free Cutoff Date</th>
            <th>Current Monthly Payment</th>
            <th>Amount</th>
            <th>Total Paid</th>
            <th class="no-sort"></th>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="8">No debts yet.</td>
        </tr>
    </tbody>
    <?php if (isset($totalDebtAmount) || isset($totalDebtPaid)) { ?>
    <tfoot>
        <?php if (isset($totalDebtAmount)) { ?>
        <tr>
            <td colspan="7">Total Debt</td>
            <td class="total-debt-amount"><?= Formatter::currency($totalDebtAmount) ?></td>
        </tr>
        <?php } ?>
        <?php if (isset($totalDebtPaid)) { ?>
        <tr>
            <td colspan="7">Total Paid Debt</td>
            <td class="total-debt-amount-paid"><?= Formatter::currency($totalDebtPaid) ?></td>
        </tr>
        <?php } ?>
    </tfoot>
    <?php } ?>
</table>
