<?php
use yii\bootstrap\ButtonDropdown;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
use backend\widgets\VideoTutorial;
?>

<?php if (isset($isMockBudget) && $isMockBudget) { ?>
<div id="body" class="container-fluid is-mock-budget" data-js-callback="debtDetailLoaded" data-select-menu="li#my-financials-debts" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-mock-budget-id="<?= $budgetId ?>">
<?php } else { ?>
<div id="body" class="container-fluid" data-js-callback="debtDetailLoaded" data-select-menu="li#my-financials-debts" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>">
<?php } ?>
    <?= VideoTutorial::widget(['type' => 'debts']) ?>
    <?php if (isset($isMockBudget) && $isMockBudget) {
        echo $this->render('/mock-budgets/_mock-budget-header', [
            'budgetId' => $budgetId,
            'budgetName' => $budgetName,
            'pageTitle' => 'Debts',
        ]);
    } ?>

    <div class="row debt-detail-headline" data-target-selector=".debt-detail-headline"<?php if (!$this->params['pageLoadRequest'] && !$fullLoad) { ?> data-partial-load="1"<?php } ?>>
        <div class="col-md-12">
            <div class="col-head">
                <h2>Debt</h2>
                <a class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/debts/add-debt', 'budget_id' => !empty($budgetId) ? $budgetId : false]) ?>"><i class="glyphicon glyphicon-plus"></i> Add</a>
            </div>

            <div class="panel panel-tabbed">
                <div class="tabpanel tabpanel-secondary">
                    <div class="container-fluid">
                        <div class="row no-gutter debt-row">
                            <div class="col-lg-6 no-float tab-col">
                                <!-- Nav tabs -->
                                <?= $this->render('_debts-list', [
                                    'debt' => $debt,
                                    'debts' => $debts,
                                    'title' => ($allowEdit) ? 'My Debts' : 'Deleted Debts',
                                    'allowEdit' => $allowEdit
                                ]); ?>
                            </div>
                            <div class="col-lg-6 no-float">
                                <!-- Tab panes -->
                                <div class="tab-content body-content debt-container" data-block-loading="true">
                                    <?= $this->render('debt-detail-content', [
                                        'debts' => $debts,
                                        'debt' => $debt,
                                        'allowEdit' => $allowEdit,
                                    ]); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-md-7">
            <div class="col-head">
                <h4>Debts</h4>
            </div>
        </div>

        <div class="col-sm-5">
            <div class="input-group">
                <input type="text" class="form-control table-search" data-search-id="d-table-1">
                <span class="input-group-addon">
                    <span class="glyphicon glyphicon-search"></span>
                </span>
            </div>
        </div>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="panel panel-table">
                <?= $this->render('_debts-table-full', [
                    'totalDebtAmount' => $totalDebtAmount,
                    'totalDebtPaid' => $totalDebtPaid,
                    'allowEdit' => $allowEdit,
                    'budgetId' => isset($budgetId) ? $budgetId : false
                ]); ?>
            </div>
        </div>
    </div>

    <?= $this->render('/layouts/_footer') ?>

</div>


