<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'remove-debt-form']); ?>
<div class="modal-body">

    <p>Do you really wish to remove this debt?</p>
    <?php if ($hardDeletable) { ?>
    <ul>
        <li><strong>Delete Debt</strong> when the debt is no longer valid (keeps past expense data). No future payments for this debt will be generated. To remove past payments of this debt, you must remove the debt transactions manually.</li>
        <li><strong>Delete Debt and all Associated Transactions</strong> when the debt was added in a mistake (deletes all past and current data)</li>
    </ul>
    <?php } else { ?>
    <p class="note">No future payments for this debt will be generated. To remove past payments of this debt, you must remove the debt transactions manually.</p>
    <?php } ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Delete Debt', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadDebtsAfterRemove'), 'data-submit-url' => Url::toRoute(['/debts/remove-debt', 'id' => $debtId, 'confirm' => '1'])]) ?>
    <?php if ($hardDeletable) { ?>
    <?= Html::submitButton('Delete Debt and all Associated Transactions', ['class' => 'btn btn-danger ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadDebtsAfterRemove'), 'data-submit-url' => Url::toRoute(['/debts/remove-debt', 'id' => $debtId, 'confirm' => 1, 'hard' => 1])]) ?>
    <?php } ?>
</div>
<?php ActiveForm::end(); ?>
