<?php
use yii\helpers\Url;
use backend\components\helpers\Formatter;

$route = ['/expenses/estimated-expenses-table', 'enhanced' => (isset($enhanced) ? $enhanced : true), 'jar_id' => $jar->id, 'allow_edit' => $allowEdit];
if (isset($jsCallback)) {
    $route += ['js_callback' => $jsCallback];
}
?>

<table id="ee-table-1" class="table table-paginated table-bordered data-table" data-table-id="ee-table-1" data-ajax="<?= Url::toRoute($route) ?>">
    <thead>
        <tr>
            <th>Expense Description</th>
            <th>Amount</th>
            <th>Expense Frequency</th>
            <th>Average Monthly Amount</th>
            <th>Due Date</th>
            <?php if ($allowEdit) { ?>
            <th class="no-sort"></th>
            <?php } ?>
        </tr>
    </thead>
    <tbody>
        <tr>
            <td colspan="<?= $allowEdit ? 6 : 5; ?>">No expenses yet.</td>
        </tr>
    </tbody>
    <?php if (isset($totalMonthlyAvg)) { ?>
    <tfoot>
        <tr>
            <td colspan="<?= $allowEdit ? 5 : 4; ?>">Total Average Monthly Expenses</td>
            <td class="this-months-estimated-exps-average"><?= Formatter::currency($totalMonthlyAvg) ?></td>
        </tr>
    </tfoot>
    <?php } ?>
</table>

