<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'pause-recurring-expense-form']); ?>
<div class="modal-body">
    <p>Do you really wish to pause this expense?</p>
</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Pause Expense', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadExpenseJarRecurringExpenses'), 'data-submit-url' => Url::toRoute(['/expenses/pause-recurring-expense', 'id' => $expenseId, 'confirm' => '1'])]) ?>
</div>
<?php ActiveForm::end(); ?>
