<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\bootstrap\ActiveForm;
use backend\components\helpers\JsTools;
?>

<div class="modal-header">
    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">×</span></button>
    <h4 class="modal-title" id="myModalLabel"><?= Html::encode($this->title) ?></h4>
</div>
<?php $form = ActiveForm::begin(['id' => 'remove-expense-form']); ?>
<div class="modal-body">

    <p>Do you really wish to remove this expense?</p>
    <?php if ($info) { ?>
    <p>
        Remove this expense if you do not need to put aside money for it anymore. Do this if the expense has been
        paid and is past its due date and you do not want it to continue.
    </p>
    <?php } ?>
    <?php if ($hardDeletable) { ?>
    <ul>
        <li><strong>Delete Expense</strong> when the expense is no longer valid (keeps past expense data)</li>
        <li><strong>Delete Expense and all Associated Transactions</strong> when the expense was added in a mistake (deletes all past and current data)</li>
    </ul>
    <?php } else { ?>
    <p>This <strong>will keep</strong> past expense data.</p>
    <?php } ?>

    <?php if (isset($frequency) && ($frequency == 'one-time') && $hardDeletable) { ?>
        <p class="note">Removing this expense will remove all associated transactions for this month and will refund all older transactions.</p>
    <?php } ?>

    <?php if ($isRecurring) { ?>
        <p class="note">No future transactions for this expense will be generated. To remove past transactions of this expense, you must remove the transactions manually (or click on <strong>Remove Expense Completely</strong>).</p>
    <?php } ?>

</div>
<div class="modal-footer">
    <?= Html::submitButton('Close', ['class' => 'btn btn-default close-modal', 'data-dismiss' => 'modal']) ?>
    <?= Html::submitButton('Delete Expense', ['class' => 'btn btn-primary ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadExpenseJarExpenses'), 'data-submit-url' => Url::toRoute(['/expenses/remove-expense', 'id' => $expenseId, 'confirm' => 1])]) ?>
    <?php if ($hardDeletable) { ?>
    <?= Html::submitButton('Delete Expense and all Associated Transactions', ['class' => 'btn btn-danger ajax-submit', 'data-js-callback' => JsTools::jsCallback($this, 'reloadExpenseJarExpenses'), 'data-submit-url' => Url::toRoute(['/expenses/remove-expense', 'id' => $expenseId, 'confirm' => 1, 'hard' => 1])]) ?>
    <?php } ?>
</div>
<?php ActiveForm::end(); ?>
