<?php
use yii\helpers\Url;

if ($currentStepId > 1) {
    $prevStepId = $currentStepId - 1;
    $prevStepUrl = "/first-time-setup/step-$prevStepId";
} else {
    $prevStepUrl = '/first-time-setup/welcome';
}

if ($currentStepId < 5) {
    $nextStepId = $currentStepId + 1;
    $nextStepUrl = "/first-time-setup/step-$nextStepId";
    $nextStepLabel = "Next Step";
} else {
    $nextStepUrl = "/first-time-setup/complete";
    $nextStepLabel = "Complete Setup";
}

$showSummary = false; //($stepProgress > 5) && ($currentStepId < 6);
$summaryUrl = "/first-time-setup/step-6";

?>
<div class="row fts-nav">
    <div class="col-sm-3">
        <a href="<?=$prevStepUrl?>" class="btn btn-secondary btn-lg btn-block fts-button">
            <i class="glyphicon glyphicon-triangle-left pull-left"></i>
            Previous Step
        </a>
    </div>

    <?php if ($showSummary) { ?>
        <div class="col-sm-3 pull-right">
            <a href="<?=$summaryUrl?>" class="btn btn-primary btn-lg btn-block fts-button">
                <i class="glyphicon glyphicon-triangle-right pull-right"></i>
                Back to Summary
            </a>
        </div>
    <?php } ?>

    <div class="col-sm-3 pull-right">
        <a href="<?=$nextStepUrl?>" class="btn btn-primary btn-lg btn-block fts-button fts-next-step"<?= $currentStepId == 7 ?
            ' onclick="$(\'.fts-add-transactions\').trigger(\'click\'); return false;"' : '' ?>>
            <i class="glyphicon glyphicon-triangle-right pull-right"></i>
            <?=$nextStepLabel?>
        </a>
    </div>
</div>
