<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
?>
<div class="row">
    <div class="col-lg-12">
        <div class="col-head">
            <h3>My Bank Accounts</h3>
            <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/accounts/add-account', 'js_callback' => 'reloadFirstTimeSetupAccounts']) ?>">
                Add a New Account
            </a>
            <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::to(['/accounts/add-account', 'js_callback' => 'reloadFirstTimeSetupAccounts', 'type' => 'cc']) ?>">
                Add a new Credit Card Account
            </a>
        </div>

        <div class="panel panel-tabbed accounts-panel">
            <div class="tabpanel tabpanel-secondary">
                <div class="container-fluid">
                    <div class="row no-gutter">
                        <div class="col-lg-6 no-float tab-col">
                            <!-- Nav tabs -->
                            <ul class="nav nav-tabs" role="tablist">
                                <?php foreach ($accounts as $key => $a) { ?>
                                <li role="presentation"<?php if ($key == 0) { ?> class="active"<?php } ?> data-account-id="<?= $a->id ?>">
                                    <a href="#acc<?= $a->id ?>" aria-controls="home" role="tab" data-toggle="tab" aria-expanded="true">
                                        <span class="clearfix">
                                            <span class="pull-left"><?= $a->name ?></span>
                                            <span class="pull-right<?php if (0 > $a->balance) { ?> gj-is-negative<?php } ?>"><?= Formatter::currency($a->balance); ?></span>
                                        </span>
                                        <?php if ($a->id == $defaultAccountId) { ?>
                                        <span class="val">Central Account</span>
                                        <?php } ?>
                                    </a>
                                </li>
                                <?php } ?>
                            </ul>
                        </div>
                        <div class="col-lg-6 no-float">
                            <!-- Tab panes -->
                            <div class="tab-content">
                                <?php foreach ($accounts as $key => $a) { ?>
                                <div role="tabpanel" class="tab-pane<?php if ($key == 0) { ?> active<?php } ?>" id="acc<?= $a->id ?>" data-account-id="<?= $a->id ?>">
                                    <div class="col-head">
                                        <h3><?= $a->name; ?></h3>
                                        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/accounts/edit-account', 'id' => $a->id, 'js_callback' => 'reloadFirstTimeSetupAccounts']) ?>" data-toggle="tooltip" title="Edit"><i class="glyphicon glyphicon-pencil gi-2x"></i></a>
                                        <a href="#" class="open-modal" data-modal-url="<?= Url::toRoute(['/accounts/remove-account', 'id' => $a->id, 'js_callback' => 'reloadFirstTimeSetupAccounts']) ?>" data-toggle="tooltip" title="Remove"><i class="glyphicon glyphicon-trash gi-2x"></i></a>
                                    </div>
                                    <div class="row">
                                        <div class="col-sm-5">
                                            <div class="label-group">
                                                <label>Balance</label>
                                                <span class="label-value<?php if (0 > $a->balance) { ?> gj-is-negative<?php } ?>"><?= Formatter::currency($a->balance) ?></span>
                                            </div>
                                            <div class="label-group">
                                                <label>Account Type</label>
                                                <span class="label-value"><?= $a->accountType->name ?></span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
