<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\Frequencies;
use backend\components\helpers\JsTools;
?>
<div class="row">
    <div class="col-lg-12">

        <div class="col-head">
            <h3>Jars &amp; Expenses</h3>
            <a href="#" class="btn btn-primary btn-sm open-modal" data-modal-url="<?= Url::toRoute(['/jars/create-expense-jar', 'js_callback' => 'reloadFirstTimeSetupJars']) ?>">Add a New Jar</a>
            <a class="btn btn-primary btn-sm reorder-jars" data-budget-id="">
                <i class="glyphicon glyphicon-move"></i>
                <span class='text'>Reorder Jars</span>
                <span class='active-text'>Save Order</span>
            </a>
        </div>

        <div class="panel panel-tabbed with-balanced-bar jars-panel">
            <div class="tabpanel tabpanel-secondary">
                <div class="container-fluid">
                    <div class="row no-gutter">
                        <div class="col-lg-6 no-float tab-col">
                            <!-- Nav tabs -->
                            <?= $this->render('_step-5-jars-list', [
                                'jars' => $jars
                            ]); ?>
                        </div>
                        <div class="col-lg-6 no-float">
                            <!-- Tab panes -->
                            <div class="tab-content body-content step-5-jar-container" data-block-loading="true">
                                <div class="tab-pane active loading-pane">Loading...</div>
                            </div>
                        </div>
                    </div>
                </div>

                <?= $this->render('_step-5-balance-bar', [
                    'totalIncomesAmount' => $totalIncomesAmount,
                    'totalExpensesAmount' => $totalExpensesAmount,
                    'incomesPctg' => $incomesPctg,
                    'expensesPctg' => $expensesPctg
                ]); ?>

            </div>
        </div>
    </div>
</div>
