<?php
use yii\bootstrap\ActiveForm;
use yii\helpers\Html;
use yii\helpers\Url;
use backend\components\helpers\Formatter;
use backend\components\helpers\JsTools;
?>
<div class="row">
    <div class="col-lg-12">
        <div class="col-head">
            <h4>This Month’s Update</h4>
        </div>
    </div>
</div>

<div class="row">
    <div class="col-lg-12">

        <div class="col-head">
            <h3>Incomes</h3>
        </div>

        <?php $form = ActiveForm::begin(['id' => 'generate-fts-entries-form']); ?>
        <div class="panel panel-table expenses-panel recurring-expenses">

            <table id="ftsi-table-1" class="table table-paginated table-bordered">
                <thead>
                    <tr>
                        <th>Add</th>
                        <th>Name</th>
                        <th>Due Date</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($incomes) && count($newIncomeTransDates)) { ?>
                    <?php foreach ($newIncomeTransDates as $key => $dates) { ?>
                    <?php foreach ($dates as $d) { ?>
                    <tr>
                        <td>
                            <?=
                            $form->field($itForm, 'generate[' . $key . '_' . $d . ']')->checkbox([
                                'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
                            ])->label('');
                            ?>
                        </td>
                        <td>
                            <?= $incomes[$key]->name ?>
                            <?=
                            $form->field($itForm, 'income_id[' . $key . '_' . $d . ']')->hiddenInput([
                                'value' => $key
                            ])->label(false);
                            ?>
                        </td>
                        <td>
                            <?= Formatter::date($d) ?>
                            <?=
                            $form->field($itForm, 'date[' . $key . '_' . $d . ']')->hiddenInput([
                                'value' => $d
                            ])->label(false);
                            ?>
                        </td>
                        <td class="amount-cell">
                            <?=
                            $form->field($itForm, 'amount[' . $key . '_' . $d . ']')->textInput([
                                'value' => isset($itForm->amount[$key . '_' . $d ]) ? $itForm->amount[$key . '_' . $d ] : $incomes[$key]->amount,
                                'class' => 'form-control amount-field'
                            ])->label(false) ?>
                            <?= Formatter::getCurrencyCode() ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php } ?>
                    <?php } else { ?>
                    <tr>
                        <td colspan="4">No income transactions.</td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>

        </div>

        <div class="col-head">
            <h3>Expenses</h3>
        </div>

        <div class="panel panel-table expenses-panel recurring-expenses">

            <table id="ftsi-table-1" class="table table-paginated table-bordered">
                <thead>
                    <tr>
                        <th>Add</th>
                        <th>Name</th>
                        <th>Due Date</th>
                        <th>Amount</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($expenses) && count($newExpenseTransDates)) { ?>
                    <?php foreach ($newExpenseTransDates as $key => $dates) { ?>
                    <?php foreach ($dates as $d) { ?>
                    <tr>
                        <td>
                            <?=
                            $form->field($tForm, 'generate[' . $key . '_' . $d . ']')->checkbox([
                                'template' => "<div class=\"checkbox\">\n{input}\n{label}\n{error}\n{hint}\n</div>"
                            ])->label('');
                            ?>
                        </td>
                        <td>
                            <?= $expenses[$key]->name ?>
                            <?=
                            $form->field($tForm, 'expense_id[' . $key . '_' . $d . ']')->hiddenInput([
                                'value' => $key
                            ])->label(false);
                            ?>
                        </td>
                        <td>
                            <?= Formatter::date($d) ?>
                            <?=
                            $form->field($tForm, 'date[' . $key . '_' . $d . ']')->hiddenInput([
                                'value' => $d
                            ])->label(false);
                            ?>
                        </td>
                        <td class="amount-cell">
                            <?=
                            $form->field($tForm, 'amount[' . $key . '_' . $d . ']')->textInput([
                                'value' => isset($tForm->amount[$key . '_' . $d ]) ? $tForm->amount[$key . '_' . $d ] : $expenses[$key]->amount,
                                'class' => 'form-control amount-field'
                            ])->label(false) ?>
                            <?= Formatter::getCurrencyCode() ?>
                        </td>
                    </tr>
                    <?php } ?>
                    <?php } ?>
                    <?php } else { ?>
                    <tr>
                        <td colspan="4">No expense transactions.</td>
                    </tr>
                    <?php } ?>
                </tbody>
            </table>

        </div>
        <?= Html::submitButton('Add Transactions', [
            'class' => 'btn btn-primary bottom-40 hidden fts-add-transactions',
            'data-js-callback' => 'ftsTransactionsAdded'
        ]) ?>
        <?php ActiveForm::end(); ?>
        <?= JsTools::viewJs($this); ?>
    </div>
</div>
