<?php
use yii\helpers\Html;
use yii\helpers\Url;
use backend\widgets\FormattedTitle;
use backend\widgets\VideoTutorial;
use backend\components\helpers\Frequencies;
use backend\components\helpers\Formatter;
?>
<div id="body" class="container-fluid no-nav" data-js-callback="firstTimeSetupStep<?= $currentStepId ?>Loaded" data-first-setup-step="<?= $currentStepId ?>" data-select-menu="li#dashboard-nav" data-page-title="<?= FormattedTitle::widget(['title' => $this->title]); ?>" data-fts-step="<?= $stepProgressFull ?>">
    <?= VideoTutorial::widget([
        'type' => "fts-$currentStepId",
        'hideable' => false
    ]) ?>
    <div class="row">
        <div class="col-lg-12">
            <?=
            $this->render('_progress-nav', [
                'currentStepId' => $currentStepId,
                'steps' => $steps,
                'stepProgress' => $stepProgress
            ]);
            ?>
        </div>
    </div>

    <?= $this->render('_step' . $currentStepId, $stepValues + [
        'formModel' => isset($formModel) ? $formModel : false
    ]); ?>

    <?= $this->render('_fts-nav', [
        'currentStepId' => $currentStepId,
        'stepProgress' => $stepProgress
    ]); ?>

    <?= $this->render('/layouts/_footer') ?>
</div>
